% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PixelIndependence.m
% ESC to exit program anytime.

%%% Program: PixelIndependence.m
function PixelIndependence(pixels)
 
%% Display Setup Module
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2;	% from monitor calibration
p.ScreenBackground = 0;

% Open display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);
HideCursor;

%% Experimental Module

% Specify the stimulus
if nargin < 1, pixels = 1; end    % pixels of half period
p.stimSize = 256;  % a quarter of stimulus size in pixels
 
% Compute stimulus parameters
n = round(p.stimSize / pixels);
sz = n * pixels;   % real number of pixels
[xc yc] = RectCenter(p.ScreenRect);
 
% Compute and make texture for grating
img = zeros(n);
img(1 : 2 : end, :) = 1;
img = Expand(img, pixels);
grating = Screen('MakeTexture', windowPtr, img, 0, 0, 2);
 
% Compute and make texture for the checker board
img = zeros(n);
img(1 : 2: end, 1 : 2 : end) = 1;
img(2 : 2: end, 2 : 2 : end) = 1;
img = Expand(img, pixels);
checker = Screen('MakeTexture', windowPtr, img, 0, 0, 2);
 
% Draw grating and check 
Screen('DrawTexture', windowPtr, grating, [], ...
       [xc-sz yc-sz xc yc]);
Screen('DrawTexture', windowPtr, grating, [], ...
       [xc+1 yc+1 xc+sz+1 yc+sz+1], 90);
Screen('DrawTexture', windowPtr, checker, [], ...
       [xc+1 yc-sz xc+sz+1 yc], 90);
Screen('DrawTexture', windowPtr, checker, [], ...
       [xc-sz yc+1 xc yc+sz+1]);
Screen('Flip', windowPtr);
 
WaitTill('esc');   % wait till ESC is pressed 

 
%% System Reinstatement Module
Screen('CloseAll'); % close window and textures

